import { TextInput, TextInputProps } from '@yandex-data-ui/common';
import { classNames, EMPTY_VALUE, formatNumber } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';

import styles from './TextInputWithCounter.module.css';

interface TextInputWithCounterProps extends Omit<TextInputProps, 'onUpdate'> {
   text?: string;
   cls?: string;
   maxLength: number;
   readonly?: boolean;
   onUpdate: (v: string) => void;
}

export const TextInputWithCounter: React.FC<TextInputWithCounterProps> = React.memo(props => {
   const counter = (
      <span className={styles.counter}>
         {formatNumber((props.text || '').toString().length)}/{formatNumber(props.maxLength)}
      </span>
   );

   const propsPatched = {
      ...props,
      className: classNames(props.cls, styles.control),
      onUpdate(text: string | number) {
         if (props.onUpdate && String(text).length <= props.maxLength) {
            props.onUpdate(String(text));
         }
      },
      value: props.text,
      theme: 'normal',
   };

   if (props.readonly) {
      return <>{props.text || EMPTY_VALUE}</>;
   }

   return (
      <div className={styles.wrapper}>
         <TextInput {...propsPatched} />
         {counter}
      </div>
   );
});

TextInputWithCounter.displayName = 'TextInputWithCounter';
