import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { TextMessage } from './TextMessage';

const TextMessageStory = () => {
   const text = 'line1 \n line2 \n line3';

   return (
      <>
         <h3>white background</h3>
         <div>
            <TextMessage isError={true} limitHeight={false} text={text} />
            <TextMessage isError={false} limitHeight={false} text={text} />
            <TextMessage isError={true} limitHeight={false} text={text} />
         </div>

         <h3>header background</h3>
         <div style={{ backgroundColor: 'var(--screen-header-bg-color)' }}>
            <TextMessage isError={true} limitHeight={false} text={text} />
            <TextMessage isError={false} limitHeight={false} text={text} />
            <TextMessage isError={true} limitHeight={false} text={text} />
         </div>

         <h3>row hovered background</h3>
         <div style={{ backgroundColor: 'var(--row-hovered-bg-color)' }}>
            <TextMessage isError={true} limitHeight={false} text={text} />
            <TextMessage isError={false} limitHeight={false} text={text} />
            <TextMessage isError={true} limitHeight={false} text={text} />
         </div>

         <h3>row without separators</h3>
         <div>
            <TextMessage isError={true} limitHeight={false} text={text} hasSeparator={false} />
            <TextMessage isError={false} limitHeight={false} text={text} hasSeparator={false} />
            <TextMessage isError={true} limitHeight={false} text={text} hasSeparator={false} />
         </div>
      </>
   );
};

storiesOf('shared/TextMessage', module).add('Text Message', () => <TextMessageStory />);
