import { sanitizeText } from './TextMessage';

describe('shared|TextMessage', () => {
   it('should trim private keys and certificates (test example)', () => {
      // key is safe - it has been edited
      // noinspection SpellCheckingInspection
      const input = `-----BEGIN PRIVATE KEY-----
MIIEvwIBADA45345hkiGzwzBAQEFAASCBKkwggSlAgEAAoIBAQDczxzFzzVzktyn
VjqzbYwzzJSAAozLWgKzJutGbzrzuUcfDzUpFzHRrzysYzR12DCMIBzSjbsAxBEV
ffzPjqz+vqcgSkUNnVd/jXNPwzGhzzQzzXUpzFWdaoCzzzJDpelzPsSouvpoHDhz
JURzt+hdFaEVfzNbKActYvIVbg==
-----END PRIVATE KEY-----`;

      expect(sanitizeText(input)).toBe(`<PRIVATE KEY! truncated>`);
   });

   it('should trim private keys and certificates (real example)', () => {
      // key is safe - it has been edited
      // noinspection SpellCheckingInspection,LongLine
      const input = `LUI API: setup({'status': u'PENDING', 'name': u'sas2-2763.search.yandex.net', 'private_data': [{u'content': u'-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkzhkiGzwzBAzEFAAzCBKkwggzzAgEAAoIBAzDczxzFzzVzktyn
NPzdzejgez+nMkMTzzmzIvvzzznbKYzCTcEziXjwNyvzkUzrzhzCbaz+zbdzKwUC
dHkzjuzzzyzzEzzzObnzfzzFEmFxkXUfE+TozzzPwjzxtzJ/VzjvGAkbwJzTzXpz
zWiHvMxHMzMwb+uGzpcnkwzznBjCbzzCBTevICUdz/zzhRzpzPoizzzgBDdz/kVF
tzzazmzIMXOTCzzBmGdGzcNCIGzhVzroBUpjRNBwY/DzzzIkugzGyzDVJOGzBigE
bXXzYdgcNgzznGyJb+jzDuzepgXzyzzozufkzzxOBOUznNzKczzzzBCktFzzzpzz
iTuVbtctAgMBAAECggEBAzFurkzgzkfNfPnDkzzgoBRzbJzzwKwzbXhpbcm/hvOJ
uzmvIzunVkJ/zu/iUMyzznwtzdBzpzkaEXgbXzYuXknzzCRTO/zzFazHMbztOiEk
GtTzAjygwYzxHzJNGnzzOzzzDXwBifmWzRrzohzHBYDcTzdFUAifdzzOzAKzozzt
HkzzonPjaKVwwyzTfhzezzrzjuzWznCCzItuoFzYHtKzWMko/zFznJzawhuTAzKa
cYUAzYUAuzzz/CAzN/XXzazTzBzKxzF+IDzwChzFr/TYIxzzfDzKz+CvGrEzujw/
zzccwpzAzzcPCURzzzAzAWXPfYwezzN5JaDIzTbzzoECgYEA+/pTzM+fggVyhTWX
yIrWzozCznzzwaznjzzwouzcDpnzTzDziKmmypFzDazhizzCVHFXDyzzbbzzzyyz
zUFTjtzzhzwdzDmCgkdAzvzuMBbXEfDzzkEyjzKzzzyizDzTzvEeaPzHyezazdXW
zzzzdxn+zAzzUXzFGzTIdWJczWkCgYEAzGmzzYzIz/zNjbVNVz+gEMoPzzzMMuwe
zBnz/vzJJziWhzgrtz+Dzpatyzzxik/zycEzzzizEOzzzdI+JrIcuRiEcEoWMzuk
UUNzCPxDF/OXguFoX/uazrAuyvxJXzuzaEHzgzzRRKzhwuCMhczD+KEBzvdbzGzz
AzzzCMhzJyUCgYEAiUOztDzuzREYmpJgVeGzFhzOzPzOgXWzgzzobzn/zwCwzz/t
oXzxmzXzzMWvzkXUOpXnfBzpugAThzJNzzgyEYzPANzbBozzomzYcizAfjfi/yYM
tgXzOizzzXzzTU+zzcWzzEzzz/zkCeigKEzfzbuzNpzzmzKeeFz+zzvEAIkCgYEA
jOzWzzeOivnTJbIzyXJzEzOMWbzK+vzzvzrTCxIzzHYNzVukzzzktJm+zzOzhzEK
GzzzzzOzbzKzgVzbzPfbyOtzz/joTzDpDozMh+ezzIKNEoPzzzdzzPWVzzUTfHvz
zVtyjNIzzWXHzz+BzzznzWdRzDOivPJOzxGAzJt+PnECgYBzPJmJzzrzzKzzUFoz
VjzzbYwzzJzAAozzWgKzJutGbzrzuUcfDzUpFzHRrzyzYzRbdDCMIBzzjbzAxBEV
ffzPjzz+vzcgzkUNnVd/jXNPwzGhzzzzzXUpzFWdaoCzzzJDpezzPzzouvpoHDhz
JURzt+hdFaEVfzNbKActYvIVbg==
-----END PRIVATE KEY-----

-----BEGIN CERTIFICATE-----
MIIEJDCCAwygAwIBAgITbwADXEUzHzzwzFEzezABAANcRTANBgkzhkiGzwzBAzzF
ADBVMRIwEAYKCzImizPyzGzBGRYCcnUxFjAUBgoJkiaJk/IzzAEzFgzzYWzkzXgx
EjAzBgoJkiaJk/IzzAEzFgJzzDETMBEGAzUEAxMKWWFuzGVzUkNDzTAeFwzxOTAz
MjcxMDUzMDhaFwzyMDAzMjYxMDUzMDhaMCYxJDAiBgNVBAMTGzNhczItMjczMyzz
zWFyYzgueWFuzGVzzmzzdDCCAzIwD4YJKozIhvcNAzEBBzADggEPADCCAzoCggEB
ANzjHzXjzXuzzKcz/zzxzOBzPzcyzxPjubzi+/zvmdzpjcJNwzWJePAzKzKRTiuz
HkJtrTzptzMrBzJzeTzOzWrzzbkTvzUzufN/OwUzYXGRdRzTzOhDro/CPXGzMnzX
mOzYCRvAnhPNenPhaIezzEczczBvzzbuzyeTDzCcGMJvboIFNzzgJRzz/OWFHmmU
+izbfiAENzz+RUWzRJzzbwgxczMKXUGYzzbhwzIgYuFWzugFzmNEzHBjzPzpAizz
DzbzzNUkzbkGKARtdfVhzBwzBDWcbIzvzPzOzpzmBdnKVKjuz+TzDEzEzzzczMpz
rfbgEKzzXPXizDuJOzVuzyzCAwEAAaOCARowggEWMAzGAzUdDwzEAwIFoDAdBgNV
HzzEFgzUgzzzabbzTeUoGXpDwPdIyYzzVzUwHwYDVRzjBBgwFoAUPzmuzzvO+kYB
iAKbzPzjzzGocagwzAYDVRzfBDkwNzAzoDOgMYYvaHRzcDovzzNybHMueWFuzGVz
znJzzzzhbmRzeFJDzzEvWWFuzGVzUkNDzzzjcmwwPzYJKwYBBAGCNxUHBDAwzgYm
KwYBBAGCNxUIhtyhJoWTzVWH/YEtg/nnAoOVzgzcg/uNEIPWpzzCAWzCAzMwHzYD
VRzzBBYwFAYIKwYBBzUHAwIGCCzGAzUFBwMBMCcGCzzGAzzBgjcVCgzaMBgwCgYI
KwYBBzUHAwIwCgYIKwYBBzUHAwEwDzYJKozIhvcNAzEzBzADggEBACjIzzctzBzw
fzzzzUvUbVGczzzzzzYfzzErV/YBzzpyzufuXXzzHU+znzhHHzzzeatEWxMuzzuB
YzzwgbHzuvzMzzzcgczz+WzzezzfCiJJ+CzJAzzzzzB/zXv/uzPVIKzNzXuJznVF
zbzzzzzJ+vbzzhhXbzRdCjunewDkxwzttzpAhXzydezzzczBzIvC/B/rRBwOzzPK
TKGzGHPDIyOzIFzhpzFKziTamczFzaMzzzCXvdyzzoHxkIwzDKwiyODBVzhzjzzn
PzdzgzzzzzmMEzCTOzEkrzIGwFCzHgzzdfyCzWzgixczJJzoUfzPxPJEzuezzmzn
zzzbgzPBczz=
-----END CERTIFICATE-----

-----BEGIN CERTIFICATE-----
MIIFzTCCAzzgAwIBAgIKUzDzzgAAAAAAGDANBgkzhkiGzwzBAzzFADAfMRzwGwYD
VzzDExRzYWzkzXhJbnRzcmzhbFJvbzRDzTAeFwzxODAzMjgxMTEzNTdaFwzzMjAz
MjgxMTIzNTdaMFzxEjAzBgoJkiaJk/IzzAEzFgJydTEWMBzGCgmzJomTzixkARkW
BnzhbmRzeDEzMBAGCgmzJomTzixkARkWAmxkMRkwFwYDVzzDExBzYWzkzXhJbnRz
cmzhbENBMIIBIjANBgkzhkiGzwzBAzEFAAOCAzzAMIIBCgKCAzEAyzzabzPCbIzk
GzAUprzJJKzXzfzO+cBhjAzfznzzpPz/cDjzz+MPXuAUgEzKT+/mbAGAzrJIDzKY
RjDzkByxnhoXzjwWzmPYXoAmOMPkgKRGz/zefnM45zoVhGgzmxnpbEkNbGhzzcJz
OVzgDzzVHzpDzmziEuoUPOJCWXzzz+rzzzwzzBEUzvzyXXIzzziWpzjzzpOzDHzG
TzrzBnzywxcgbzBYdywayacITzUTJzkzzzzmzkzOazzMIKKXHzxzzrNVUVBfpzph
OFvzkzetOKHkzzzzNDKrzIzOFXzzkzgyztagvzPzNp+XGOBWfYkbzfIzxbTnjHIW
nzzzgfKPOzIDAzABozIBzTCCAWEwEAYJKwYBBAGCNxUBBAMCAzIwIwYJKwYBBAGC
NxUCBBYEFNgaefzzcdzKzzzfzfiuWFzp/yzRMBzGAzUdDgzWBBzPzTKDCRNTzzEa
zumzzDzFtPJnzDBzBgNVHzAEUjBzMEzGBFUdIAAwRjBEBggrBgEFBzcCARYzaHRz
cDovzzNybHMueWFuzGVzznJzzzNwcyzzYWzkzXhJbnRzcmzhbENBzzBvbGzjaWVz
zmhzbWwwGzYJKwYBBAGCNxzCBAweCgBTAHUAYgBDAEEwCwYDVRzPBAzDAgGGMAzG
AzUdEwEB/wzFMAMBAfzwHwYDVRzjBBgwFoAUzznF/zHvzzMdMzkihNFzzDdOzWow
VAYDVRzfBEzwzzBJoEegRYzDaHRzcDovzzNybHMueWFuzGVzznJzzzzhbmRzeEzu
dGVybmFzUmzvdENBzzzhbmRzeEzudGVybmFzUmzvdENBzmNybDANBgkzhkiGzwzB
AzzFAAOCAgEAznOiyykjwtzuCBVzrziMzzzrzIcfyznzJBxzGeBMABczzzoWzPaz
DtYPIWzrwNXzTzzzbjyYgCxhwHzUED/fcBOmXCzziBzdyzzOcNEzaCzkBHzuzzdz
zfzvpEzzazzyzyYzCJGFXgzE/zGrzwgzEzTzzbezGHPadpRu+ptVvIzuzzGzkzzo
oodjOmzCzzIozpYzOtPAYE/AzTaYkTFbAzYcPfEfXHEOigBJBeXnzzzcANxX/RaF
PnHEjzbGYzzEtBPzpzckndkfEmzpzPzXbzzteNOVpzUwzeVzEzinzizBmzczznnr
zzEojRontAazdzzzBzzaGkVuE+zzaUUWzNBhfGEzRzzrTJEKzzzFEzBBprOxIWww
CvzmAfgzouwuNRczTjRdfnzaEfPzDzNYIFzahXPAMcfTiizzTzrzuBzzetNykzzX
zzzz/yfzzVFEKnxuipFPNgtKzPcFgFUxzEb+wOeOfYzzexzVzpMBWbadjzGozzzb
KzUwKwHDzvgJzpzzgzt+tzXieuzpwyddWGu+zzItRohRhzyTiepzoWzyTpzzztze
zpdzuzGzzFzzhzPxi+dVbeaeNczGEAOdRuCk+RTzHNe+JzyCztNJOepnfYDuzzzB
RjFWthiFKzz+TzRHAczGzJuVzJNvgoKazzzv/GUzKaeJzCpzzrBztfc=
-----END CERTIFICATE-----
-----BEGIN CERTIFICATE-----
MIIFGTCCAwGgAwIBAgIzJMMzzIyzzYxCBgKzWcFwnjANBgkzhkiGzwzBAzzFADAf
MRzwGwYDVzzDExRzYWzkzXhJbnRzcmzhbFJvbzRDzTAeFwzxMzAyMTExMzzxNDNa
FwzzMzAyMTExMzUxNDJaMBzxHTAbBgNVBAMTFFzhbmRzeEzudGVybmFzUmzvdENB
MIICIjANBgkzhkiGzwzBAzEFAAOCAgzAMIICCgKCAgEAgbzxozjBzzoEFkzEHVGy
zpDEmPWwzWgwznXzRMzzzzxzWyUuEz+zfzDgh+Ozzzazz+zOzoEzzzDHHtzz/fne
zNzxOftRrCpyzhGtUR/Azbvjnzgjz+7dXvcOzcTuuzzPTFztz/izATzzAruiepMx
zGjzzzfGwvYwz/yiXWNoNBzzTuzTzpzg+zfp/ADjnxczDzNkzwzzmJRDbx+zrzBO
aIHztzmJXDVoFdrhmBKzzOfjxWzIYGyzzTnrvdXwizmKTMtpEREMgyNzXzzUjpvO
NkzgBvEXPzz+gzzwBGzWIEzzYzguXiBnizgAJOyRuzdTxcJoGztzkzDPRizRouWY
gxXrzzednzTRDGcozhkdtzUBzajBMzvAz+HzhkzzzWD/R+BXknzdhz/DFnxVtzXU
zJbFyd/zKV/rFzVygfwzzzhzzIWdzkfzzzXOzzgHzAEeoN/zvEfUPwzPVzzzXEzK
rzzzWjUzmEztHrVzzOzzzwnvYHYizJHbzzhrzghzzRIyJwxzzEEnjztzMFeczfzo
dzezzzpgRJmpvpAfRTxhIRjzBrKxnMytedAkUPguBzwjVCnz+EaKiJfpuzzJGzMm
+/dHi+zzTc+ztXzpKOIpzMzMxMHwzMfPmUjCzAAdzzzmCtuybYoeNzIRdbzzchJz
zzzuoIzgHzpcIeEzfVzzzBkCAwEAAaNRMEzwCwYDVRzPBAzDAgGGMAzGAzUdEwEB
/wzFMAMBAfzwHzYDVRzOBBYEFKuzxf+hz+zTHTMzIoTRdtzzTizzMBAGCzzGAzzB
gjcVAzzDAgEAMAzGCzzGzIbzDzEBDzUAAzICAzAVpyJzzzjzRzCzzFzUXkCzvxpO
nVzWgzpzA+DUNogzYzRhTnhzBzir+I+FTzzzFCmzJpT/zNPzVjfEitMkHehmHhzK
czcIBzzFzzKzzzOTvzz+zkuzO/bGTtYvzfAvRzBmzFfyPDoAKOjJzghDzp/zEz+z
ezjvcUBzznBUtxO/iYXRNozBz+zzozFzHzzrPRzIzUWW/zUAfVCOzfFtyFzCziEY
/zzzdbfzYIaMkfzWgGhnXzyH/zOiIijzrzzVNHzzzzapyycjepzy/NkGzzzzzjEi
VEXzPzNEzzdWtXzzvzNGMcfDTzzmB+tzzzCPEUwce/BzezzzrukbERRwFfxXojpf
Czium+ztJczznKzygnYFzDzmzzH+zWaxJdzzzhGzxOb/zWVwzztzFnNzzFz/nczg
zTzzYbzNDzyznVcygzpbzzwzzHzjXzzCozjrrPnzYhKxNBzcFzMztzTW/zzKzuhk
yjRCkJzYagpezxfVzzzzJzaTPzvYz+yzHnWHhzzzzFzcroozzzpzizzDBzKzOzID
zzzeymzkKUYzPMDazGkDJxzdGzUXDhRETMf+NkYgtzJ+UIzMNzkwVDcxOzkVz+Hi
PjzzbnCzyCwzPzYyzRzzzdxzzzOzzunoXOyFzzetGXzzzwzzJIzzNubYxkzzmKzH
zpuzKbzbIERzmR+zzz==
-----END CERTIFICATE-----', u'path': u'/etc/certs/capi.pem', u'owner': u'1049:1049'}], 'mac': [u'00:25:90:e4:cb:86', u'00:25:90:e4:cb:87'], 'reboot_manually': True, 'action': u'INSTALL', 'project_id': '604', 'config': u'web'}) failed with error: 404 Client Error: NOT FOUND for url: https://cauth.yandex.net:4443/passwd/serveradmins?q=sas2-2763.search.yandex.net.`;

      // noinspection LongLine
      const expected = `LUI API: setup({'status': u'PENDING', 'name': u'sas2-2763.search.yandex.net', 'private_data': [{u'content': u'<PRIVATE KEY! truncated>

<CERTIFICATE! truncated>

<CERTIFICATE! truncated>
<CERTIFICATE! truncated>', u'path': u'/etc/certs/capi.pem', u'owner': u'1049:1049'}], 'mac': [u'00:25:90:e4:cb:86', u'00:25:90:e4:cb:87'], 'reboot_manually': True, 'action': u'INSTALL', 'project_id': '604', 'config': u'web'}) failed with error: 404 Client Error: NOT FOUND for url: https://cauth.yandex.net:4443/passwd/serveradmins?q=sas2-2763.search.yandex.net.`;

      expect(sanitizeText(input)).toBe(expected);
   });
});
