import { classNames, Rows } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';

import styles from './TextMessage.module.css';

interface IProps {
   cls?: string;
   hasSeparator?: boolean;
   isError?: boolean;
   limitHeight?: boolean;
   text: string;
   title?: string;
}

export const TextMessage = React.memo(
   ({ cls = '', isError = false, limitHeight = true, text, title = '', hasSeparator = true }: IProps) => {
      return (
         <div
            title={title}
            className={classNames(styles.message, cls, {
               [styles.limitHeight]: limitHeight,
               [styles.error]: isError,
               [styles.hasSeparator]: hasSeparator,
            })}
         >
            <Rows text={text} />
         </div>
      );
   },
);

TextMessage.displayName = 'TextMessage';

export function sanitizeText(text: string): string {
   return text.replace(/[-]+BEGIN ([\w\s]+?)[-]+([\n\da-z+/=]*)[-]+END \1[-]+/gi, '<$1! truncated>');
}
