import { styleHelpers } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { useCallback } from 'react';

interface IProps {
   ticket: string;
}

const TRACKER_URL_PREFIX = 'https://st.yandex-team.ru/';

export const TrackerLink = React.memo(({ ticket }: IProps) => {
   const href =
      ticket.startsWith('https://') || ticket.startsWith('http://') ? ticket : `${TRACKER_URL_PREFIX}${ticket}`;

   const text = href.startsWith(TRACKER_URL_PREFIX) ? href.replace(TRACKER_URL_PREFIX, '') : href;

   const stop = useCallback((e: React.MouseEvent) => {
      e.stopPropagation();
   }, []);

   return (
      <a href={href} onClick={stop} className={styleHelpers.externalLink} target={'_blank'} rel={'noopener noreferrer'}>
         {text}
      </a>
   );
});

TrackerLink.displayName = 'TrackerLink';
