import { IUserOrGroup, UserName, UserOrGroupType } from '@yandex-infracloud-ui/libs-next';
import { SystemUsersContext } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useContext } from 'react';

interface Props {
   value: string;
}

export const UserOrSystemName: React.FC<Props> = React.memo(({ value }) => {
   const systemUsers = useContext(SystemUsersContext);

   const issuer: IUserOrGroup = systemUsers.has(value)
      ? { type: UserOrGroupType.System, id: value }
      : { type: UserOrGroupType.People, id: value.replace(/@$/, '') };

   return <UserName value={issuer} />;
});

UserOrSystemName.displayName = 'UserOrSystemName';
