import { storiesOf } from '@storybook/react';
import { json } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { UserSelect, UserSelectMode } from './UserSelect';

interface IProps {
   mode: UserSelectMode;
}

function EditableUserSelectStory({ mode }: IProps) {
   // hooks
   const [value, setValue] = useState<string | null>(null);

   // handlers
   const update = (e: SyntheticEvent, v: string | null) => setValue(v);

   // render
   return (
      <>
         <UserSelect onSelect={update} mode={mode} />

         <pre>{json(value)}</pre>
      </>
   );
}

storiesOf('shared|UserSelect', module)
   .add('issuers', () => <EditableUserSelectStory mode={UserSelectMode.Issuers} />)
   .add('owners', () => <EditableUserSelectStory mode={UserSelectMode.Owners} />);
