import { IStaffGroup, IStaffPerson, SuggestLayer } from '@yandex-infracloud-ui/libs-next';
import { normalizeValue, UserSelectMode } from './UserSelect';

describe('shared|UserSelect', () => {
   describe('normalizeValue', () => {
      it('should return null if item is null', () => {
         expect(normalizeValue(null, UserSelectMode.Issuers)).toBeNull();
         expect(normalizeValue(null, UserSelectMode.Owners)).toBeNull();
      });

      it('should return @group for owners', () => {
         const item = {
            layer: SuggestLayer.Groups,
            slug: 'group',
         } as Partial<IStaffGroup>;

         expect(normalizeValue(item as IStaffGroup, UserSelectMode.Owners)).toBe('@group');
      });

      it('should return login for owners', () => {
         const item = {
            layer: SuggestLayer.People,
            login: 'login',
         } as Partial<IStaffPerson>;

         expect(normalizeValue(item as IStaffPerson, UserSelectMode.Owners)).toBe('login');
      });

      it('should return login@ for issuers', () => {
         const item = {
            layer: SuggestLayer.People,
            login: 'login',
         } as Partial<IStaffPerson>;

         expect(normalizeValue(item as IStaffPerson, UserSelectMode.Issuers)).toBe('login@');
      });
   });
});
