import { boolean } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import { json } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { VLANsSelect } from './VLANsSelect';

const items = new Set([556, 777, 444, 1604, 1, 2, 3, 4, 5, 6, 7, 44345, 345, 45, 25, 36, 45, 32, 7678, 789]);

function RegularStory({ value: initialValue }: { value: Set<number> }) {
   // hooks
   const [value, setValue] = useState(initialValue);

   // handlers
   function updateValue(e: SyntheticEvent | null, v: Set<number>) {
      setValue(v);
   }

   // render
   return (
      <>
         <VLANsSelect items={items} readonly={boolean('readonly', false)} value={value} onChange={updateValue} />

         <pre>{json(value)}</pre>
      </>
   );
}

storiesOf('shared|VLANsSelect', module)
   .add('regular', () => <RegularStory value={new Set([777, 1604])} />)
   .add('empty', () => <RegularStory value={new Set()} />);
