import * as H from 'history';
import * as React from 'react';
import { ReactNode, SyntheticEvent } from 'react';

import { IBoxes, IHost, IProject, IScenario, UserModel } from '../models';

/**
 * Текущий пользователь
 * @deprecated use state.globals.user
 */
export const UserContext = React.createContext<UserModel | null>(null);

/**
 * @deprecated use useLocation() from react-router package
 */
export const LocationContext = React.createContext<H.Location<any> | null>(null);

export interface IHostContextValue {
   boxes: IBoxes | null;
   canEdit: boolean;
   canRunHostAction: boolean;
   error: string;
   host: IHost | null;
   isLoading: boolean;
   isShadow: boolean;

   onChange(e: SyntheticEvent | null, host: IHost): void;
}

// Для вкладок на странице хоста
export const HostContext = React.createContext<IHostContextValue>({
   boxes: null,
   canEdit: false,
   canRunHostAction: false,
   error: '',
   host: null,
   isLoading: false,
   isShadow: false,
   onChange: () => undefined,
});

interface IHostListAdditionalColumn {
   order: number;
   render: (host: IHost) => ReactNode;
   title: string;
}

export interface IHostListContext {
   additionalColumns: IHostListAdditionalColumn[];
   hideProjectColumn: boolean;
}

export const HostListContext = React.createContext<IHostListContext>({
   additionalColumns: [],
   hideProjectColumn: false,
});

export interface IScenarioContextValue {
   isLoading: boolean;
   scenario?: IScenario;
}

export const ScenarioContext = React.createContext<IScenarioContextValue>({
   isLoading: false,
});

export interface IProjectContextValue {
   error: string;
   isLoading: boolean;
   project: IProject | null;
   readonly: boolean;

   onChange(e: SyntheticEvent, project: IProject): void;
}

export interface IPreorderContextValue {
   acquired_hosts: number[];
   errors: string[];
   failed_hosts: number[];
   isLoading: boolean;
   messages: string[];
   preorderId: string;
}

export const PreorderContext = React.createContext<IPreorderContextValue>({
   acquired_hosts: [],
   errors: [],
   failed_hosts: [],
   isLoading: false,
   messages: [],
   preorderId: '',
});

// Для вкладок на странице проекта
export const ProjectContext = React.createContext<IProjectContextValue>({
   error: '',
   isLoading: false,
   onChange: () => undefined,
   project: null,
   readonly: true,
});

export const ProjectIdContext = React.createContext<string>('');
