import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { HostHealthStatus } from '../../models';
import { fullWidthOutlineDecorator } from '../../stories';

import { HealthCheckList } from './HealthCheckList';
import { IHostHealthItem } from './healthGroups';

const items: IHostHealthItem[] = [
   { name: 'switch', status: HostHealthStatus.Passed },
   { name: 'rack', status: HostHealthStatus.Invalid },
];

storiesOf('shared|host_health/HealthCheckList', module)
   .addDecorator(fullWidthOutlineDecorator)
   .add('block', () => <HealthCheckList items={items} inline={false} />)
   .add('inline', () => <HealthCheckList items={items} inline={true} />);
