import { capitalize, classNames } from '@yandex-infracloud-ui/libs-next';
import { Popup } from '@yandex-data-ui/common';
import * as React from 'react';
import { RefObject, useCallback, useRef, useState } from 'react';
import { HELP_HINTS } from '../../models';

import styles from './HealthCheckList.module.css';
import { IHostHealthItem } from './healthGroups';
import paletteStyles from './palette.module.css';

interface IItemProps {
   item: IHostHealthItem;
}

const HealthCheckItem = React.memo(({ item }: IItemProps) => {
   // hooks
   const [visible, setVisible] = useState(false);
   const ref: RefObject<HTMLSpanElement> = useRef() as any; // TODO fix typing

   // handlers
   const show = useCallback(() => setVisible(true), []);
   const hide = useCallback(() => setVisible(false), []);

   // render
   return (
      <>
         <span ref={ref} onClick={show} className={styles.item}>
            <span className={styles.icon} /> {item.name}
         </span>
         <Popup anchorRef={ref} open={visible} onOutsideClick={hide} placement={'right'}>
            <div className={styles.title}>
               {item.status}: {HELP_HINTS.healthCheckStatuses[item.status]}
            </div>
         </Popup>
      </>
   );
});

HealthCheckItem.displayName = 'HealthCheckItem';

interface IProps {
   inline: boolean;
   items: IHostHealthItem[];
}

export const HealthCheckList = React.memo(({ items, inline }: IProps) => {
   return (
      <ul className={classNames(styles.list, paletteStyles.palette, { [styles.inline]: inline })}>
         {items.map(item => (
            <li key={item.name} className={classNames(styles.status, styles[`status${capitalize(item.status)}`])}>
               <HealthCheckItem item={item} />
            </li>
         ))}
      </ul>
   );
});

HealthCheckList.displayName = 'HealthCheckList';
