import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { HostHealthStatus, IConstantGroups, IHostHealthStatuses } from '../../models';
import { outlineDecorator } from '../../stories';
import { HostHealth } from './HostHealth';

const healthGroups: IConstantGroups = {
   availability: ['unreachable', 'ssh'],
   hardware: ['memory', 'disk', 'link', 'bmc', 'cpu', 'overheat', 'cpu_capping'],
   infrastructure: ['switch', 'rack'],
   software: ['meta', 'walle_meta', 'reboots', 'tainted_kernel', 'fs_check'],
};

const healthPartly: IHostHealthStatuses = {
   bmc: HostHealthStatus.Failed,
   cpu: HostHealthStatus.Passed,
   cpu_capping: HostHealthStatus.Passed,
   disk: HostHealthStatus.Passed,
   fs_check: HostHealthStatus.Passed,
   link: HostHealthStatus.Missing,
   memory: HostHealthStatus.Passed,
   net64_check: HostHealthStatus.Passed,
   reboots: HostHealthStatus.Suspected,
};

storiesOf('shared|host_health/HostHealth', module)
   .addDecorator(outlineDecorator)
   .add('All from enum', () => {
      const groups: IConstantGroups = Object.values(HostHealthStatus).reduce((acc, status) => {
         acc[status] = [status];

         return acc;
      }, {});

      const value = Object.values(HostHealthStatus).reduce((acc, status) => {
         acc[status] = status;

         return acc;
      }, {});

      return <HostHealth groups={groups} value={value} restrictions={undefined} />;
   })
   .add('Partly statuses', () => <HostHealth groups={healthGroups} value={healthPartly} restrictions={undefined} />);
