import { LazyDropdown } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { IConstantGroups, IHostHealthStatuses } from '../../models';

import { groupByType } from './healthGroups';
import styles from './HostHealth.module.css';
import { HostHealthChecks } from './HostHealthChecks';
import { HostHealthIndicator } from './HostHealthIndicator';
import { RestrictionsNote } from './RestrictionsNote';

interface IProps {
   groups: IConstantGroups;
   restrictions: Set<string> | undefined;
   value: IHostHealthStatuses;
}

export const HostHealth = React.memo((props: IProps) => {
   const grouped = groupByType(props.value, props.groups);

   const switcher = <HostHealthIndicator groups={grouped} />;

   return (
      <LazyDropdown switcher={switcher} direction={'free'}>
         <HostHealthChecks cls={styles.popup} groups={grouped}>
            <RestrictionsNote value={props.restrictions} />
         </HostHealthChecks>
      </LazyDropdown>
   );
});

HostHealth.displayName = 'HostHealth';
