import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { HostHealthStatus, IConstantGroups, IHostHealthStatuses } from '../../models';
import { groupByType, IHostHealthGroup } from './healthGroups';
import { HostHealthChecks } from './HostHealthChecks';

const healthGroups: IConstantGroups = {
   availability: ['unreachable', 'ssh'],
   hardware: ['memory', 'disk', 'link', 'bmc', 'cpu', 'overheat', 'cpu_capping'],
   infrastructure: ['switch', 'rack'],
   software: ['meta', 'walle_meta', 'reboots', 'tainted_kernel', 'fs_check'],
};

const healthWithLongNames: IHostHealthStatuses = {
   bmc: HostHealthStatus.Passed,
   cpu: HostHealthStatus.Passed,
   cpu_capping: HostHealthStatus.Passed,
   disk: HostHealthStatus.Passed,
   fs_check: HostHealthStatus.Passed,
   link: HostHealthStatus.Passed,
   memory: HostHealthStatus.Passed,
   net64_check: HostHealthStatus.Passed,
   overheat: HostHealthStatus.Passed,
   rack: HostHealthStatus.Invalid,
   reboots: HostHealthStatus.Passed,
   ssh: HostHealthStatus.Passed,
   switch: HostHealthStatus.Passed,
   tainted_kernel: HostHealthStatus.Passed,
   unreachable: HostHealthStatus.Passed,
   walle_host_certificate: HostHealthStatus.Passed,
   walle_host_certificate2: HostHealthStatus.Passed,
   walle_host_certificate3: HostHealthStatus.Passed,
   walle_meta: HostHealthStatus.Passed,
};

storiesOf('shared|host_health/HostHealthChecks', module)
   .add('All from enum', () => {
      const groups: IHostHealthGroup[] = [
         {
            items: Object.values(HostHealthStatus).map(s => ({ name: s, status: s })),
            name: 'All statuses',
            status: HostHealthStatus.Failed,
         },
      ];

      return <HostHealthChecks groups={groups} />;
   })
   .add('Long names', () => {
      const groups = groupByType(healthWithLongNames, healthGroups);

      return (
         <div style={{ maxWidth: '20rem', outline: '1px dotted gray' }}>
            <HostHealthChecks groups={groups} />
         </div>
      );
   });
