import { classNames } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { PropsWithChildren } from 'react';
import { HealthCheckList } from './HealthCheckList';

import { IHostHealthGroup } from './healthGroups';
import styles from './HostHealthChecks.module.css';
import paletteStyles from './palette.module.css';

interface IProps {
   cls?: string;
   groups: IHostHealthGroup[];
}

export const HostHealthChecks = React.memo(({ cls = '', groups, children }: PropsWithChildren<IProps>) => (
   <div className={classNames(paletteStyles.palette, cls)}>
      {children}

      <div className={styles.items}>
         {groups.map(group => (
            <div key={group.name}>
               <h4>{group.name}</h4>
               <HealthCheckList items={group.items} inline={false} />
            </div>
         ))}
      </div>
   </div>
));

HostHealthChecks.displayName = 'HostHealthChecks';
