import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { HostHealthStatus } from '../../models';

import { IHostHealthGroup } from './healthGroups';
import { HostHealthIndicator } from './HostHealthIndicator';

storiesOf('shared|host_health/HostHealthIndicator', module).add('All from enum', () => {
   const allItems = Object.values(HostHealthStatus).map(s => ({ name: s, status: s }));

   const groups: IHostHealthGroup[] = allItems.map(i => ({
      items: [...allItems],
      name: i.name,
      status: i.status,
   }));

   return <HostHealthIndicator groups={groups} />;
});
