import { capitalize, classNames, formatNumber, styleHelpers } from '@yandex-infracloud-ui/libs';
import { array } from 'prop-types';
import * as React from 'react';

import { HELP_HINTS } from '../../models';

import { IHostHealthGroup } from './healthGroups';
import styles from './HostHealthIndicator.module.css';
import paletteStyles from './palette.module.css';

interface IProps {
   groups: IHostHealthGroup[];
}

export class HostHealthIndicator extends React.PureComponent<IProps> {
   public static defaultProps = {};

   public static propTypes = {
      groups: array.isRequired,
   };

   public render() {
      const checkCount = this.props.groups.reduce((acc, group) => {
         acc += group.items.length;

         return acc;
      }, 0);

      return (
         <div className={classNames(styles.hostHealthIndicator, paletteStyles.palette)}>
            <span className={classNames(styles.indicatorCount, styleHelpers.rightSpace)}>
               {formatNumber(checkCount)}
            </span>

            {this.props.groups.map(group => (
               <div
                  key={group.name}
                  title={`${group.name}: ${HELP_HINTS.healthCheckStatuses[group.status]}`}
                  className={classNames(styles[`indicator${capitalize(group.status)}`], styles.indicator)}
               />
            ))}
         </div>
      );
   }
}
