import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { RestrictionsNote } from './RestrictionsNote';

const allRestrictions = new Set([
   'reboot',
   'profile',
   'redeploy',
   'automation',
   'automated-healing',
   'automated-reboot',
   'automated-profile',
   'automated-redeploy',
   'automated-repairing',
   'automated-memory-change',
   'automated-disk-change',
   'automated-link-repair',
   'automated-bmc-repair',
   'automated-cpu-repair',
   'automated-overheat-repair',
   'automated-capping-repair',
   'automated-rack-repair',
   'automated-dns',
]);

storiesOf('shared|host_health/RestrictionsNote', module)
   .add('One', () => (
      <div style={{ marginLeft: '1rem' }}>
         <RestrictionsNote value={new Set(['automated-capping-repair'])} />
      </div>
   ))
   .add('Two', () => (
      <div style={{ marginLeft: '1rem' }}>
         <RestrictionsNote value={new Set(['redeploy', 'profile'])} />
      </div>
   ))
   .add('All', () => (
      <div style={{ marginLeft: '1rem' }}>
         <RestrictionsNote value={allRestrictions} />
      </div>
   ));
