import { _formatRestrictionNoteText } from './RestrictionsNote';

describe('RestrictionsNote', () => {
   /*
      const allRestrictions = [
         'reboot',
         'profile',
         'redeploy',
         'automation',
         'automated-healing',
         'automated-reboot',
         'automated-profile',
         'automated-redeploy',
         'automated-repairing',
         'automated-memory-change',
         'automated-disk-change',
         'automated-link-repair',
         'automated-bmc-repair',
         'automated-cpu-repair',
         'automated-overheat-repair',
         'automated-capping-repair',
         'automated-rack-repair',
         'automated-dns',
      ];
   */

   it('format for no restrictions', () => {
      expect(_formatRestrictionNoteText(new Set([]))).toBe('');
   });

   it('format for one restriction', () => {
      expect(_formatRestrictionNoteText(new Set(['reboot']))).toBe('reboot restriction is on');

      expect(_formatRestrictionNoteText(new Set(['automated-healing']))).toBe('automated-healing restriction is on');

      expect(_formatRestrictionNoteText(new Set(['automated-cpu-repair']))).toBe(
         'automated-cpu-repair restriction is on',
      );
   });

   it('format for two restrictions', () => {
      expect(_formatRestrictionNoteText(new Set(['redeploy', 'profile']))).toBe(
         'redeploy and profile restrictions are on',
      );
   });

   it('format for three restrictions', () => {
      expect(_formatRestrictionNoteText(new Set(['redeploy', 'profile', 'automated-dns']))).toBe(
         'redeploy, profile and automated-dns restrictions are on',
      );
   });

   it('format for lots of restrictions', () => {
      expect(
         _formatRestrictionNoteText(
            new Set(['redeploy', 'profile', 'automated-dns', 'automated-overheat-repair', 'reboot']),
         ),
      ).toBe('redeploy, profile, automated-dns, automated-overheat-repair and reboot restrictions are on');
   });
});
