import { formatStringList, isEmpty } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import styles from './RestrictionsNote.module.css';

export function RestrictionsNote(props: { value: Set<string> | undefined }) {
   if (isEmpty(props.value)) {
      return null;
   }

   return <div className={styles.restrictions}>{_formatRestrictionNoteText(props.value)}</div>;
}

export function _formatRestrictionNoteText(values: Set<string>): string {
   if (isEmpty(values)) {
      return '';
   }

   const strings = Array.from(values);

   if (values.size === 1) {
      return `${strings[0]} restriction is on`;
   }

   return `${formatStringList(...strings)} restrictions are on`;
}
