import {
   IdSet,
   idSetToList,
   idSetToSet,
   listToEntityStore,
   listToIdSet,
   toggleIdSet,
   toggleListItem,
} from './commonModels';

describe('state|commonModels', () => {
   it('listToIdSet', () => {
      const ids = ['a', 'b', 'c'];

      expect(listToIdSet(ids)).toEqual({
         a: true,
         b: true,
         c: true,
      });
   });

   it('idSetToList', () => {
      expect(idSetToList({ a: true, b: true, c: false })).toEqual(['a', 'b']);
   });

   it('idSetToSet', () => {
      expect(idSetToSet({ a: true, b: true, c: false })).toEqual(new Set(['a', 'b']));
   });

   it('toggleIdSet', () => {
      const set: IdSet = {
         a: true,
         b: true,
         c: true,
      };

      expect(toggleIdSet(set, 'a')).toEqual({
         b: true,
         c: true,
      });

      expect(toggleIdSet(set, 'w')).toEqual({
         a: true,
         b: true,
         c: true,
         w: true,
      });
   });

   it('toggleListItem', () => {
      const list = ['a', 'b', 'c'];

      expect(toggleListItem(list, 'a')).toEqual(['b', 'c']);

      expect(toggleListItem(list, 'w')).toEqual(['a', 'b', 'c', 'w']);
   });

   it('listToEntityStore', () => {
      const list = [
         { id: 'a', name: 'A' },
         { id: 'b', name: 'B' },
         { id: 'c', name: 'C' },
      ];

      expect(listToEntityStore(list)).toEqual({
         allIds: ['a', 'b', 'c'],
         byIds: {
            a: { id: 'a', name: 'A' },
            b: { id: 'b', name: 'B' },
            c: { id: 'c', name: 'C' },
         },
      });
   });
});
