export interface IdSet {
   [id: string]: boolean;
}

interface Entity {
   id: string;
}

/**
 * @deprecated (only export)
 */
export interface EntitySet<T extends Entity> {
   [id: string]: T;
}

export interface EntityStore<T extends Entity> {
   allIds: string[];
   byIds: EntitySet<T>;
}

export const listToIdSet = (ids: string[]) => {
   return ids.reduce((acc, id) => {
      acc[id] = true;

      return acc;
   }, {} as IdSet);
};

export const idSetToList = (set: IdSet): string[] => {
   return Object.keys(set).filter(k => set[k]);
};

export const idSetToSet = (set: IdSet): Set<string> => {
   return new Set(idSetToList(set));
};

export const toggleIdSet = (idSet: IdSet, id: string) => {
   const result = { ...idSet };
   if (result.hasOwnProperty(id)) {
      delete result[id];
   } else {
      result[id] = true;
   }

   return result;
};

export const toggleListItem = (list: string[], id: string) => {
   const result = [...list];
   const i = result.indexOf(id);
   if (i > -1) {
      result.splice(i, 1);
   } else {
      result.push(id);
   }

   return result;
};

export const createEmptyEntityStore = <T extends Entity>(): EntityStore<T> => ({ byIds: {}, allIds: [] });

export const listToEntityStore = <T extends Entity>(entities: T[]): EntityStore<T> => {
   const store = createEmptyEntityStore<T>();

   for (const entity of entities) {
      store.allIds.push(entity.id);
      store.byIds[entity.id] = entity;
   }

   return store;
};
