import { addSetItem, deepClone } from '@yandex-infracloud-ui/libs';
import { config } from 'services';
import { ProjectOwners } from '../../models';
import { idFromName } from '../../utils';
import { ActionType, setBasicFields, SyncAction } from './actions';
import { FullProjectFormState, initialState, projectToFormParams } from './models';
import {
   basicValidatorExternal,
   basicValidatorInternal,
   cauthValidator,
   cmsValidator,
   deployingValidator,
   profilingValidator,
} from './validators';

export const reducer = (state = initialState, action: SyncAction): FullProjectFormState => {
   // const validationContext = {constants: state.constants};

   switch (action.type) {
      case ActionType.AddOwner: {
         const _owners = state.basic.params._owners!;
         const toAdd = addSetItem(_owners.toAdd, action.login);

         const basic = {
            ...state.basic.params,
            _owners: { ..._owners, toAdd } as ProjectOwners,
            owners: addSetItem(state.basic.params.owners ?? new Set<string>(), action.login), // TODO remove
         };

         return reducer(state, setBasicFields(basic));
      }

      case ActionType.Clear: {
         return initialState;
      }

      case ActionType.SetBasicFields: {
         let isIdChangedManually = state.isIdChangedManually;
         if (!isIdChangedManually) {
            if (state.basic.params.id !== action.params.id) {
               isIdChangedManually = true;
            } else {
               action.params.id = idFromName(action.params.name);
            }
         }

         return {
            ...state,
            basic: {
               params: action.params,
               validation: config.isExternal
                  ? basicValidatorExternal(action.params)
                  : basicValidatorInternal(action.params),
            },
            isIdChangedManually,
         };
      }

      case ActionType.SetCms: {
         return {
            ...state,
            cmsSettings: action.cmsSettings.map((e, index) => {
               if (action?.index === index && action.params) {
                  return {
                     params: action.params,
                     validation: cmsValidator(action.params, { constants: action.constants }),
                  };
               }

               return { ...e, validation: cmsValidator(e.params, { constants: action.constants }) };
            }),
         };
      }

      case ActionType.AddCms: {
         return {
            ...state,
            cmsSettings: [
               ...state.cmsSettings,
               {
                  params: action.params,
                  validation: cmsValidator(action.params, { constants: action.constants }),
               },
            ],
         };
      }

      case ActionType.SetCAuthFields: {
         return {
            ...state,
            cauth: {
               params: action.params,
               validation: cauthValidator(action.params),
            },
         };
      }

      case ActionType.SetVlans: {
         return {
            ...state,
            vlans: {
               params: action.params,
               validation: state.vlans.validation, // TODO
            },
         };
      }

      case ActionType.SetDeploying: {
         return {
            ...state,
            deploying: {
               params: action.params,
               validation: deployingValidator(action.params, { constants: action.constants }),
            },
         };
      }

      case ActionType.SetProfiling: {
         return {
            ...state,
            profiling: {
               params: action.params,
               validation: profilingValidator(action.params),
            },
         };
      }

      case ActionType.SetAutomationLimits: {
         return {
            ...state,
            automationLimits: {
               params: action.params,
               validation: state.automationLimits.validation, // TODO
            },
         };
      }

      case ActionType.SetHostLimits: {
         return {
            ...state,
            hostLimits: {
               params: action.params,
               validation: state.automationLimits.validation, // TODO
            },
         };
      }

      case ActionType.SetOthers: {
         return {
            ...state,
            others: {
               params: action.params,
               validation: state.others.validation,
            },
         };
      }

      case ActionType.SetPlots: {
         return {
            ...state,
            plots: {
               params: action.params,
               validation: state.plots.validation, // TODO
            },
         };
      }

      case ActionType.SetRestrictions: {
         return {
            ...state,
            restrictions: {
               params: action.params,
               validation: state.restrictions.validation, // TODO
            },
         };
      }

      case ActionType.SetDisabledChecks: {
         return {
            ...state,
            disabledChecks: {
               params: action.params,
               validation: state.disabledChecks.validation, // TODO
            },
         };
      }

      case ActionType.SetNotifications: {
         return {
            ...state,
            notifications: {
               params: action.params,
               validation: state.notifications.validation, // TODO
            },
         };
      }

      case ActionType.SetReports: {
         return {
            ...state,
            reports: {
               params: action.params,
               validation: state.reports.validation, // TODO
            },
         };
      }

      case ActionType.SetAutomations: {
         return {
            ...state,
            automations: {
               params: action.params,
               validation: state.automations.validation, // TODO
            },
         };
      }

      case ActionType.SetProject: {
         const newState = projectToFormParams(state, action.params, action.owners);

         return {
            ...newState,
            originalProject: deepClone(newState),
         };
      }

      case ActionType.SetNewProject: {
         return { ...state, isNewProject: true };
      }

      case ActionType.Reset: {
         if (state.isNewProject) {
            return initialState;
         } else {
            const newState: FullProjectFormState | null = state.originalProject;

            return newState || initialState;
         }
      }

      default: {
         return state;
      }
   }
};
