import { createSlice, PayloadAction } from '@reduxjs/toolkit';

import { IConstants, UserModel } from '../../models';

const initialState = {
   constants: null as IConstants | null,
   user: null as UserModel | null,
};

export type GlobalsState = typeof initialState;

export const globalsSlice = createSlice({
   initialState,
   name: 'globals',
   reducers: {
      setConstants(state, action: PayloadAction<IConstants>) {
         state.constants = action.payload;
      },
      setUser(state, action: PayloadAction<UserModel>) {
         state.user = action.payload;
      },
   },
});
