import { ThunkAction } from 'redux-thunk';
import { projectApi } from '../../services';
// noinspection ES6PreferShortImport,TypeScriptPreferShortImport
import { loadUser } from '../globals/asyncActions';
import { ProjectItem, ProjectState } from './models';
import { projectsSlice } from './slice';

type ThunkResult<R> = ThunkAction<R, { projects: ProjectState }, undefined, any>;

export const loadProjects = (skipIfLoaded = false): ThunkResult<void> => (dispatch, getState) => {
   const projectState = getState().projects;

   if (skipIfLoaded && (projectState.wasLoaded || projectState.requested)) {
      return;
   }

   dispatch(projectsSlice.actions.setRequested());
   dispatch(projectsSlice.actions.setLoading(true));

   projectApi.getList().subscribe(
      projects => {
         const items: ProjectItem[] = projects.result as any; // FIXME any
         dispatch(projectsSlice.actions.setLoaded(items));
      },
      // TODO handle error
   );
};

export const addProject = (project: ProjectItem): ThunkResult<void> => dispatch => {
   dispatch(projectsSlice.actions.addProject(project));
   dispatch(loadUser(false)); // reload for updating projects.userProjects
};
