import { IListOption } from '@yandex-infracloud-ui/libs';

import { IProject, OwnershipValue, ProjectType } from '../../models';
// noinspection ES6PreferShortImport
import { config } from '../../services/config';
import { createEmptyEntityStore, IdSet } from '../commonModels';

export type ProjectItem = Pick<
   IProject,
   'id' | 'dns_automation' | 'dns_domain' | 'fsm_handbrake' | 'healing_automation' | 'name' | 'reboot_via_ssh' | 'type'
> & { tags?: string[]; deploy_tags?: string[] };

export enum AutomationFilterValue {
   All = 'all',
   AllOn = 'all_on',
   AllOff = 'all_off',
   HealingOff = 'healing_off',
   DnsOff = 'dns_off',
   FsmOn = 'fsm_on',
}

export const AutomationFilters: IListOption[] = [
   { value: AutomationFilterValue.All, name: 'All status' },
   { value: AutomationFilterValue.AllOn, name: 'All automations are on' },
   { value: AutomationFilterValue.AllOff, name: 'All automations are off' },
   { value: AutomationFilterValue.HealingOff, name: 'Healing automation is off' },
   { value: AutomationFilterValue.DnsOff, name: 'DNS-automation is off' },
   { value: AutomationFilterValue.FsmOn, name: 'FSM-handbrake is on' },
];

export enum TypeFilterValueAll {
   All = 'all',
}

export type TypeFilterValue = TypeFilterValueAll & ProjectType;

export const TypeFilters: IListOption[] = [
   { value: TypeFilterValueAll.All, name: 'All types' },
   { value: ProjectType.SERVER, name: 'Server' },
   { value: ProjectType.VM, name: 'VM' },
   { value: ProjectType.MAC, name: 'MAC' },
   { value: ProjectType.SHADOW, name: 'Shadow-server' },
];

export interface ProjectFilters {
   automation: AutomationFilterValue;
   ownership: OwnershipValue;
   query: string;
   type: TypeFilterValue;
}

export const initialState = {
   allItems: createEmptyEntityStore<ProjectItem>(),
   filteredIds: [] as string[],
   filters: {
      automation: AutomationFilterValue.All,
      ownership: config.ownershipDefault,
      query: '',
      type: TypeFilterValueAll.All,
   } as ProjectFilters,
   isAllSelected: false,
   isCollapsed: config.isProjectListCollapsed,
   selectedIds: {} as IdSet,
   title: '',
   titleForUnselected: '',
   userProjects: [] as string[],
   deployTags: [] as string[],
   projectTags: [] as string[],

   isLoading: true,
   wasLoaded: false,
   requested: false,
};

export type ProjectState = typeof initialState;
