import { createSelector } from '@reduxjs/toolkit';
import { idSetToList } from './commonModels';
import { RootState } from './store';

export const singleSelectedMyProjectIdSelector = createSelector(
   (s: RootState) => s.projects.selectedIds,
   (s: RootState) => s.globals.user?.projects,
   (s: RootState) => s.globals.user?.isAdmin,

   (selectedIds, userProjects, isAdmin) => {
      const selected = idSetToList(selectedIds);
      if (selected.length !== 1) {
         return null;
      }

      const userProjectsSet = new Set(userProjects || []);
      const projectId = selected[0];

      return isAdmin || userProjectsSet.has(projectId) ? projectId : null;
   },
);
