import { Action, configureStore, getDefaultMiddleware, ThunkAction } from '@reduxjs/toolkit';
import { Middleware } from 'redux';
import { createLogger } from 'redux-logger';

import { preordersReducer } from '../routes/preorders/_list/preordersSlice';
import { reducer as fullProjectForm } from './fullProjectForm/reducer';
import { globalsSlice } from './globals';
import { projectsSlice } from './projects';

export const store = configureStore({
   devTools: true,
   middleware: [
      ...getDefaultMiddleware({
         serializableCheck: false,
      }),
      createLogger({ collapsed: true }) as Middleware,
   ],
   reducer: {
      fullProjectForm,
      globals: globalsSlice.reducer,
      projects: projectsSlice.reducer,
      preorders: preordersReducer,
   },
});

export type RootState = ReturnType<typeof store.getState>;

export type AppThunk = ThunkAction<void, RootState, unknown, Action<string>>;
