import { StoryFn } from '@storybook/addons';
import { ActionContainer } from '@yandex-infracloud-ui/libs-next';
import {
   maintenancePlotActions,
   MaintenancePlotSubject,
   maintenancePlotActionService,
} from '../../actions/maintenance_plot_actions';
import * as React from 'react';

import {
   automationPlotActions,
   automationPlotActionService,
   AutomationPlotSubject,
} from '../../actions/automation_plot_actions';
import { hostActions, hostActionService, HostSubject } from '../../actions/host_actions';
import { IAutomationPlot, IHost, IMaintenancePlot } from '../../models';

export function actionsSupportDecorator(story: StoryFn) {
   return (
      <>
         <ActionContainer
            actionStore={{
               [HostSubject]: {
                  actions: hostActions,
                  resolveNameFromContext: (hosts: IHost[]) => hosts.map(h => h.name),
                  service: hostActionService,
               },
               [AutomationPlotSubject]: {
                  actions: automationPlotActions,
                  resolveNameFromContext: (plot: IAutomationPlot) => [plot.id],
                  service: automationPlotActionService,
               },
               [MaintenancePlotSubject]: {
                  actions: maintenancePlotActions,
                  resolveNameFromContext: (plot: IMaintenancePlot) => [plot.id],
                  service: maintenancePlotActionService,
               },
            }}
         />
         {story()}
      </>
   );
}
