import { radios } from '@storybook/addon-knobs';
import { StoryFn } from '@storybook/addons';
import '@yandex-data-ui/common/styles/styles.scss';
import '@yandex-data-ui/common/styles/themes.scss';

export function globalStylesDecorator(story: StoryFn) {
   require('../../design/common.css');
   require('../../design/storybook-preview.css');

   const theme = radios('UI theme', { 'light': 'light', 'dark': 'dark' }, 'light');

   document.body.classList.add('yc-root');
   document.body.classList.add(`yc-root_theme_${theme}`);
   document.body.classList.replace(`yc-root_theme_${theme === 'dark' ? 'light' : 'dark'}`, `yc-root_theme_${theme}`);

   return story();
}
