import { StoryFn } from '@storybook/addons';
import * as React from 'react';
import { CSSProperties, ReactNode } from 'react';

export function outlineDecorator(story: StoryFn<ReactNode>) {
   const style: CSSProperties = {
      display: 'inline-block',
      outline: '1px dotted var(--color-gray)',
   };

   return <div style={style}>{story()}</div>;
}

export function fullWidthOutlineDecorator(story: StoryFn<ReactNode>) {
   const style: CSSProperties = {
      outline: '1px dotted var(--color-gray)',
   };

   return <div style={style}>{story()}</div>;
}
