import { StoryFn } from '@storybook/addons';
import { Json, useBehaviourSubject } from '@yandex-infracloud-ui/libs';
import { Tumbler } from 'lego-on-react';
import { default as React, PropsWithChildren, useCallback, useEffect } from 'react';

import { globalState, UserModel } from '../../models';

function createTestUser(isAdmin: boolean) {
   return new UserModel('khoden', 'khoden', 'khoden', isAdmin, 'api', [], ['test', 'sandbox-mtn', 'yp-man'], {}, []);
}

export const UserSwitcher = ({ children }: PropsWithChildren<any>) => {
   const user = useBehaviourSubject(globalState.user);

   const isAdmin = user ? user.isAdmin : false;

   useEffect(() => {
      globalState.user.next(createTestUser(false));
   }, []);

   const toggle = useCallback(() => {
      globalState.user.next(createTestUser(!isAdmin));
   }, [isAdmin]);

   return (
      <>
         <div
            style={{
               borderBottom: 'var(--border-gray)',
               marginBottom: '1rem',
            }}
         >
            <Tumbler theme={'normal'} size={'s'} checked={isAdmin} onChange={toggle}>
               <Tumbler.Off id={''} side={'right'} text={'User'} />
               <Tumbler.On id={''} side={'left'} text={'Admin'} />
            </Tumbler>
            <div style={{ height: '1rem' }} />
            <details>
               <summary>UserModel dump</summary>
               <Json obj={globalState.user.value} />
            </details>
         </div>

         {children}
      </>
   );
};

UserSwitcher.displayName = 'UserSwitcher';

export const userSwitcherDecorator = (story: StoryFn) => <UserSwitcher>{story()}</UserSwitcher>;
