import { useCallback, useState } from 'react';
import { FormParams } from '../state/fullProjectForm';

export function useFormParams<T>(initialValue: FormParams<T>): [FormParams<T>, (v: T) => void] {
   const [value, setValue] = useState(initialValue);

   const update = useCallback((params: T) => setValue(v => ({ ...v, params })), []);

   return [value, update];
}
