import { storiesOf } from '@storybook/react';
import { HttpMethod, toasts } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import * as React from 'react';
import { useEffect } from 'react';
import { auth, config, sentry } from '../services';
import { WalleBaseApi } from '../services/api/base_api';
import { toastsSupportDecorator } from './decorators/toastsSupportDecorator';

class ErrorApi extends WalleBaseApi {
   public get502Error() {
      return this.request(HttpMethod.GET, '502');
   }
}

const errorApi = new ErrorApi(`${config.walleApi}/v1`);

const SentryToastsStory = () => {
   const handlerToast = () => toasts.error('toast error text', 'toast error title');

   useEffect(() => {
      sentry.init();
      auth.init();
   }, []);

   return (
      <>
         <Button theme={'normal'} size={'s'} onClick={handlerToast}>
            Toast Error
         </Button>
      </>
   );
};

const SentryApiStory = () => {
   const handlerApi = () =>
      errorApi.get502Error().subscribe(
         resp => console.log(resp),
         resp => {
            toasts.apiError('Test 502 request', resp);
            console.warn(resp);
         },
      );

   useEffect(() => {
      sentry.init();
      auth.init();
   }, []);

   return (
      <Button theme={'normal'} size={'s'} onClick={handlerApi}>
         API Error
      </Button>
   );
};

storiesOf('other|Sentry', module)
   .addDecorator(toastsSupportDecorator)
   .add('Toast error', () => <SentryToastsStory />)
   .add('API error', () => <SentryApiStory />);
