/* tslint:disable:no-reference */
/// <reference path="../node_modules/@yandex-data-ui/common/build/esm/typings/bem-cn-lite.d.ts" />
/// <reference path="../node_modules/@yandex-data-ui/common/build/esm/typings/global.d.ts" />
/// <reference path="../node_modules/@yandex-data-ui/common/build/esm/typings/staff-card.d.ts" />

declare module 'lru-memoize' {
   function memoize(
      limit?: number,
      equals?: (a: any, b: any) => boolean,
      deepObjects?: boolean,
      // tslint:disable-next-line:ban-types
   ): <T extends Function>(func: T) => T;

   export default memoize;
}

// tslint:disable:interface-name
declare module 'lego-on-react' {
   export interface PopupProps {
      motionless?: boolean;
   }
}

declare module '@yandex-data-ui/infra-buzzer' {
   import * as React from 'react';
   import { Store } from 'redux';

   export const store: Store;

   export const PRODUCTION: string;

   interface ISubscription {
      environmentId?: number;
      serviceId: number;
   }

   interface InfraBuzzerProps {
      environment: string;
      subscribeTo: ISubscription[];
   }

   export class InfraBuzzer extends React.Component<InfraBuzzerProps> {}
}

// tslint:disable-next-line:no-namespace
declare module 'react-json-syntax-highlighter' {
   import * as React from 'react';

   interface ReactJsonSyntaxHighlighterProps {
      /**
       * фейковый props для использования CSS Modules
       */
      cls?: string;
      obj: any;
   }

   // tslint:disable-next-line:max-classes-per-file
   export default class ReactJsonSyntaxHighlighter extends React.Component<ReactJsonSyntaxHighlighterProps> {}
}

// tslint:disable-next-line:no-namespace
declare namespace jest {
   // tslint:disable-next-line:interface-name
   // eslint-disable-next-line @typescript-eslint/no-unused-vars
   interface Matchers<R, T> {
      toBeInvalid(field: string, errors: string[]): R;

      toBeValid(): R;
   }
}

interface IInfraBuzzerService {
   environmentId: number;
   serviceId: number;
}

interface IUiConfig {
   feedbackFormId: number;
   idmStand: 'idm.test' | 'idm';
   idmSystemId: 'walle-testing' | 'walle';
   infraBuzzer: IInfraBuzzerService[] | IInfraBuzzerService | false;
   metrika: false | number;
   profiling: boolean;
   sentryDsn: false | string;
   staffApi: string;
   startrekApi: string;
   installationType: string;
   walleApi: string;
}

interface Window {
   UI_CONFIG?: IUiConfig;
}

// tslint:disable-next-line:no-namespace
declare namespace React {
   interface HTMLAttributes<T> extends React.AriaAttributes, React.DOMAttributes<T> {
      'data-e2e'?: string;
   }
}
