import { createIdGenerator, getIntRandom } from './forTests';

describe('test utils', () => {
   it('should createIdGenerator return sequentially growing id', () => {
      const nextId = createIdGenerator();

      expect(nextId()).toBe(1);
      expect(nextId()).toBe(2);
      expect(nextId()).toBe(3);
      expect(nextId()).toBe(4);
      expect(nextId()).toBe(5);
   });

   it('should get random', () => {
      for (let i = 0; i < 100; i += 1) {
         expect(getIntRandom(0, i)).toBeLessThanOrEqual(i);
      }

      for (let i = 0; i < 100; i += 1) {
         const value = getIntRandom(100, 100 + i);
         expect(value).toBeGreaterThanOrEqual(100);
         expect(value).toBeLessThanOrEqual(100 + i);
      }
   });
});
