import { YCSelectItem } from '@yandex-data-ui/common';
import { fromQuery, toQuery } from '@yandex-infracloud-ui/libs';
import { isAfter, isBefore } from 'date-fns';
import * as H from 'history';

/**
 * @file Временное пристанище для разных штук, которы следует перенести в общую библиотеку
 */
export function limitNumber(v: number, min: number, max: number): number {
   if (v < min) {
      return min;
   }
   if (v > max) {
      return max;
   }

   return v;
}

export function limitDate(v: Date, min: Date, max: Date): Date {
   if (isBefore(v, min)) {
      return min;
   }

   if (isAfter(v, max)) {
      return max;
   }

   return v;
}

/**
 * Проверяет актуальность данных (факт того, что deadline еще не наступил)
 *
 * @param deadlineTimestamp Временная метка актуальности (до этой метки значение считается актуальным).
 *        Задаётся в секундах.
 */
export function isActual(deadlineTimestamp: number) {
   return isAfter(new Date(deadlineTimestamp * 1000), new Date());
}

export function patchUrlQuery(history: H.History, location: H.Location, patch: { [k: string]: any }) {
   const params = fromQuery(location.search);
   const newParams = { ...params, ...patch };

   const newSearch = toQuery(newParams);
   if (newSearch !== location.search.replace(/^\?/, '')) {
      history.push({ search: newSearch });
   }
}

export const arrayToYCSelectItem = (arr: string[]): YCSelectItem[] => {
   return arr.map(e => ({ value: e, title: e }));
};
