from __future__ import unicode_literals

import six
from gevent.lock import RLock

METRICS = {
    'stuck_snapshots': 'attx',
    'unprocessed_cleanup_snapshots': 'attx',
    'stalled_meta_tasks': 'attx',
    'status_ctl_unprocessed_taskgroups': 'attx',
    'enqueued_tasks': 'attx',
    'orphaned_pod_sets': 'attx',
    'deploy_engine_url_missing_pod_sets': 'attx',
    'not_processed_domains_pod_sets': 'attx',
    'last_mtime_skip_pod_sets': 'attx',
    'missed_completed_taskgroups': 'attx',
    'eviction_requested_24_hours': 'attx',
    'eviction_requested_48_hours': 'attx',
    'eviction_requested_72_hours': 'attx',

}


class Metrics(object):
    def __getattr__(self, item):
        if item not in METRICS:
            raise AttributeError(item)
        self.__dict__[item] = Counter()
        return self.__dict__[item]

    def __repr__(self):
        lines = []
        for metric, suffix, metric_attr in self._get_metrics():
            lines.append('{}_{}: {}'.format(metric, suffix, metric_attr))
        return '\n' + '\n'.join(lines)

    __str__ = __repr__

    def dump(self):
        result = []
        for metric, suffix, metric_attr in self._get_metrics():
            result.append({
                'name': '{}_{}'.format(metric, suffix),
                'val': metric_attr.get(),
            })
        return result

    def set(self, item, value):
        if item not in METRICS:
            raise AttributeError(item)
        self.__dict__[item] = Counter(value)

    def _get_metrics(self):
        for metric, suffix in six.iteritems(METRICS):
            metric_attr = self.__dict__.get(metric, None)
            if metric_attr is not None:
                yield metric, suffix, metric_attr


class Counter(object):
    def __init__(self, value=0):
        self._counter = value
        self._lock = RLock()

    def set(self, value=0):
        with self._lock:
            self._counter = value

    def inc(self, value=1):
        with self._lock:
            self._counter += value

    def clear(self):
        with self._lock:
            self._counter = 0

    def get(self):
        result = self._counter
        self.clear()
        return result

    def __repr__(self):
        return str(self._counter)

    __str__ = __repr__
