from __future__ import unicode_literals
import datetime

from nanny_repo import repo_pb2, repo_api_pb2


class Taskgroup(object):

    MIN_BROKEN_PERIOD = datetime.timedelta(hours=5)
    COMPLETED_TASKGROUP_STATUSES = ('DONE', 'CANCELLED', 'REJECTED')

    def __init__(self, tg_id, s_id, sn_pb):
        self.tg_id = tg_id
        self.s_id = s_id
        self.sn_pb = sn_pb

    def is_missed_completed(self, alemate_client):
        if datetime.datetime.utcnow() - self.sn_pb.last_transition_time.ToDatetime() < self.MIN_BROKEN_PERIOD:
            return False
        sn_status = repo_pb2.SnapshotStatus.Status.Name(self.sn_pb.status)
        if not sn_status.endswith('ING') or sn_status == 'DEACTIVATE_PENDING':
            return False
        try:
            tg_status = alemate_client.get_taskgroup_status(self.tg_id)
        except Exception:
            return False
        return tg_status in self.COMPLETED_TASKGROUP_STATUSES


def list_services(repo_client):
    req = repo_api_pb2.ListServicesRequest()
    return repo_client.list_services(req).services


def find_missed_completed_taskgroups(repo_client, alemate_client):
    tgs = []
    for s_pb in list_services(repo_client):
        for sn_pb in s_pb.status.snapshot:
            tg_started_status = sn_pb.taskgroup_started.status
            if not tg_started_status or tg_started_status == 'false':
                continue
            tg = Taskgroup(tg_id=sn_pb.taskgroup_id,
                           s_id=s_pb.id,
                           sn_pb=sn_pb)
            if tg.is_missed_completed(alemate_client):
                tgs.append(tg)
    return tgs
