from __future__ import unicode_literals

import json

import requests


class PushClient(object):
    def __init__(self, yasm_host, yasm_port, metrics_ttl, ctype, prj, geo):
        self.session = requests.Session()
        self.url = 'http://{}:{}'.format(yasm_host, yasm_port)
        self.json = [{
            'tags': {
                'itype': 'push',
                'ctype': ctype,
                'prj': prj,
                'geo': geo,
            },
            'ttl': metrics_ttl,
        }, ]

    def send_metrics(self, metrics, log, ttl=None):
        if ttl is not None:
            self.json[0]['ttl'] = ttl
        self.json[0]['values'] = metrics.dump()
        log.info(json.dumps(self.json))
        resp = self.session.post(self.url, json=self.json)
        resp.raise_for_status()
        log.info(resp.json())
