import six
from infra.swatlib import pbutil
from nanny_repo import repo_pb2


def get_current_and_target(sn, sn_status):
    """
    :type sn: nanny_repo.repo_pb2.Snapshot
    :type sn_status: nanny_repo.repo_pb2.SnapshotStatus
    :rtype: nanny_repo.repo_pb2.Snapshot.Target, nanny_repo.repo_pb2.SnapshotStatus.Status, unicode, unicode
    """
    if sn:
        target = sn.target
        target_name = pbutil.enum_value_to_name(repo_pb2.Snapshot.Target.DESCRIPTOR, target)
    else:
        target_name = target = None
    if sn_status:
        current = sn_status.status
        current_name = pbutil.enum_value_to_name(repo_pb2.SnapshotStatus.Status.DESCRIPTOR, current)
    else:
        current_name = current = None
    return current, current_name, target, target_name


def iter_snapshots(snapshots, snapshot_statuses):
    """
    Iterates over target_state, current_state for every snapshot.
    Every time target_state or current_state (but not both) can be None.

    :type snapshots: list[nanny_repo.repo_pb2.Snapshot]
    :type snapshot_statuses: list[nanny_repo.repo_pb2.SnapshotStatus]
    """
    status_index = {i.id: i for i in snapshot_statuses}
    for sn in snapshots:
        status = status_index.pop(sn.id, None)
        yield sn.id, sn, status
    # current_states_index now contains only currently present snapshots that are not
    # required on hosts in any state
    for status in six.itervalues(status_index):
        yield status.id, None, status
