from collections import OrderedDict

from infra.watchdog.src.lib.yp_client import YpObject, yson_loads
from yp_proto.yp.client.api.proto import autogen_pb2


class PodSet(YpObject):
    NANNY_WATCHDOG_LABELS_PATH = '/labels/nanny_watchdog_marks'

    object_type = autogen_pb2.OT_POD_SET
    selectors = OrderedDict([
        ('/meta/id', ('obj_id', yson_loads)),
        ('/spec/account_id', ('account_id', yson_loads)),
        ('/labels', ('labels', lambda data: yson_loads(data, default={}))),

    ])
    __slots__ = ('obj_id', 'labels', 'account_id')

    def __repr__(self):
        return 'PodSet(obj_id={})'.format(self.obj_id)

    @property
    def deploy_engine(self):
        """

        :rtype: six.text_type | None
        """
        return self.labels.get('deploy_engine')

    @property
    def deploy_engine_url(self):
        """

        :rtype: six.text_type | None
        """
        return self.labels.get('yp.deploy_engine_url')

    @property
    def nanny_service_id(self):
        """

        :rtype: six.text_type | None
        """
        return self.labels.get('nanny_service_id')

    @property
    def nanny_watchdog_marks(self):
        """

        :rtype: dict[six.text_type, six.text_type]
        """
        return self.labels.get('nanny_watchdog_marks', {})

    @property
    def exists_nanny_watchdog_marks(self):
        """

        :rtype: bool
        """
        return 'nanny_watchdog_marks' in self.labels
