from __future__ import unicode_literals

import kazoo.exceptions
from nanny_repo import repo_pb2

PATH_STATES = '/services/service_states'
PATH_CLEANUP = '/cleanup_policies/'


class ZkClient(object):
    def __init__(self, zk_client):
        self._client = zk_client

    def start(self):
        self._client.start().wait()

    def stop(self):
        self._client.stop()

    def get_service_states_list(self):
        return self._client.get_children(PATH_STATES)

    def get_service_state(self, s_id):
        try:
            return self._get_pb(s_id, root_path=PATH_STATES, pb_class=repo_pb2.Service)
        except:
            return None

    def get_service_ids(self):
        """

        :rtype: list[six.text_type]
        """
        return self._client.get_children(PATH_STATES)

    def get_cleanup_policies_list(self):
        return self._client.get_children(PATH_CLEANUP)

    def get_cleanup_policy(self, service_id):
        try:
            return self._get_pb(service_id, root_path=PATH_CLEANUP, pb_class=repo_pb2.CleanupPolicy)
        except:
            return None

    def _get_pb(self, s_id, root_path, pb_class):
        """
        :param s_id:
        :param pb_class:
        :param root_path:
        :rtype
        :return:
        """
        path = '{}/{}'.format(root_path, s_id)
        try:
            dump, node_stat = self._client.read_file(path)
        except kazoo.exceptions.NoNodeError:
            return None
        s_pb = pb_class()
        try:
            s_pb.ParseFromString(dump)
        except:
            return None
        return s_pb
