"""
CMD ya-salt disable
"""
import datetime
import logging

from infra.ya_salt.lib import constants
from infra.ya_salt.lib import runutil

log = logging.getLogger('ya-salt')


def add_command(action):
    p = action.add_parser('disable', help='Disable auto ya-salt (for {} sec)'.format(constants.TIMEOUT_DISABLE))
    p.set_defaults(handle=handler)


def handler(_):
    log.setLevel(level=logging.INFO)
    f = runutil.Flag()
    adjusted, err = f.touch()
    if err is not None:
        log.error("Failed to touch disable flag '{}': {} ".format(constants.FILE_DISABLE_RUN, err))
        return False
    # Here we assume that it is precise enough to manually calculate expiration time.
    exp = datetime.datetime.now() + datetime.timedelta(seconds=f.get_expire_time())
    # Format only hour and minutes to avoid clutter as we do not delay too far into future.
    till = exp.strftime('%H:%M')
    if adjusted:
        log.info("Was disabled. Adjusted till {} at '{}'.".format(till, constants.FILE_DISABLE_RUN))
    else:
        log.info("Disabled ya-salt till {} at '{}'".format(till, constants.FILE_DISABLE_RUN))
    log.info('To enable use `ya-salt enable`.')
    return True
