"""
CMD ya-salt enables
"""
import logging

from infra.ya_salt.lib import runutil

log = logging.getLogger('salt-run')


def add_command(action):
    p = action.add_parser('enable', help='Enable auto ya-salt')
    p.set_defaults(handle=handler)


def handler(_):
    log.setLevel(level=logging.INFO)
    f = runutil.Flag()
    disabled, exists = f.is_enforced()
    if not disabled:
        log.info("Hostman is already enabled.")
    if exists:
        err = f.remove()
        if err is not None:
            log.error('Failed to remove flag: {}'.format(err))
        else:
            log.info("Removed disabling flag")
    return True
