"""
CMD ya-salt exec
"""
import logging

import sys

from library.python import svn_version

from infra.ya_salt.hostmanager import shim_exec

from infra.ya_salt.lib import constants
from infra.ya_salt.lib import context
from infra.ya_salt.lib import logutil
from infra.ya_salt.lib import output
from infra.ya_salt.lib import policy
from infra.ya_salt.lib import runutil
from infra.ya_salt.lib import statusutil

log = logging.getLogger('ya-salt')


def add_command(action):
    p = action.add_parser('exec', help='Execute ya-salt component')
    p.add_argument('path', help='Path to ya-salt component')
    p.set_defaults(handle=handler)


def handler(args):
    log_level = logging.INFO
    if args.debug:
        log_level = logging.DEBUG
    manual = sys.stdin.isatty()
    # Force console output if we're logging to terminal
    logutil.setup_logging(log_level, args.log_file, manual)
    ok, _ = runutil.lock_run(constants.F_LOCK_EX)
    if not ok:
        log.fatal('{} is locked - exiting.'.format(constants.F_LOCK_EX))
        return True
    log.info("=== ya-salt exec=2.0-{} started as '{}' ===".format(
        svn_version.svn_revision(), ' '.join(sys.argv)))
    execution_policy = policy.FailFast()
    ctx = context.Ctx(policy=execution_policy)
    status, err = shim_exec.run_exec(ctx, args.path)
    if err is not None:
        log.error('HM run failed with error: {}'.format(err))
        return False
    if manual:
        sys.stdout.write(output.pformat_exec(status, short=True))
    _, _, fail = statusutil.get_executed_states_results(status.salt_components)
    return fail == 0 and statusutil.get_executed_states_count(status.salt_components) > 0
