"""
CMD ya-salt grains. Reads hm-spec file and prints grains if any.
"""
from __future__ import print_function

import json

from infra.ya_salt.lib import constants
from infra.ya_salt.lib import persist
from infra.ya_salt.lib import yamlutil


def add_command(action):
    p = action.add_parser('grains', help='Return json grains')
    p.add_argument('-i', '--item', help='Get key example : --item KEY',
                   default=None, required=False)
    p.add_argument('-p', '--path', help='Path to spec file (default: %(default)s)',
                   default=constants.SPEC_PATH)
    p.add_argument('-o', '--out', help='Format print result', default='yaml', choices=['yaml', 'json'])
    p.set_defaults(handle=handler)


def handler(args, _):
    spec, err = persist.load_spec(args.path)
    if err is not None:
        print("Failed to load status: {}".format(err))
        print("Maybe ya-salt has not run yet? Try running `ya-salt run` as root.")
        return False
    if not spec.salt.grains_json:
        print("No grains in spec.")
        print("Maybe ya-salt has not run yet? Try running `ya-salt run` as root.")
        return False
    try:
        d = json.loads(spec.salt.grains_json)
    except Exception as e:
        print("Failed to parse grains as JSON: {}".format(e))
        print("Please report this to st/HOSTMAN")
        return False
    if args.item is not None:
        rv = d.get(args.item)
    else:
        # Return all grains
        rv = d
    if args.out == 'json':
        print(json.dumps(rv, sort_keys=True, indent=4), end='')
    else:
        print(yamlutil.prettify(rv), end='')
    return True
