"""
Render specified component.
"""

from infra.ya_salt.hostmanager import shim

from infra.ya_salt.lib import constants
from infra.ya_salt.lib import saltutil
from infra.ya_salt.lib import info
from infra.ya_salt.lib import yamlutil


def add_command(action):
    p = action.add_parser('render', help='render specified component')
    p.add_argument('--repo',
                   help='path to repository root (default: %(default)s',
                   default=constants.LOCAL_REPO_CURRENT)
    p.add_argument('-n', '--name',
                   required=True,
                   help='component name, e.g kernel')
    p.set_defaults(handle=handler)


def handler(args):
    m = shim.LocalMode(args.repo)
    g, err = info.load_grains()
    if err is not None:
        print(err)
        return
    repo, err = m.init_repo(g)
    if err is not None:
        print(err)
        return
    high, err = repo.render_high_selector(saltutil.Selector(repo.get_env(), 'deploy.' + args.name))
    if err is not None:
        print(err)
        return False
    print(yamlutil.prettify(high.states()))
