"""
Load and print hostmanager spec.
"""
import errno
import sys

from google.protobuf import json_format
import yaml

from infra.ya_salt.lib import persist


def add_command(action):
    p = action.add_parser('spec', help='Get spec')
    p.add_argument('-o', '--output',
                   choices=['json', 'yaml'],
                   default='yaml',
                   help='Output format (default: %(default)s)')
    p.set_defaults(handle=handler)


def handler(args):
    spec, err = persist.load_spec()
    if err is not None:
        sys.stderr.write('Failed to load spec '
                         '(maybe has not run yet?): {}\n'.format(err))
        return False
    else:
        if args.output == 'json':
            buf = json_format.MessageToJson(spec,
                                            including_default_value_fields=True,  # For .jq grep
                                            sort_keys=True,  # To be able to test
                                            )
        elif args.output == 'yaml':
            d = json_format.MessageToDict(spec, including_default_value_fields=True)
            buf = yaml.safe_dump(d)
        else:
            sys.stderr.write('Unsupported output format: {}'.format(args.output))
            return False
        try:
            sys.stdout.write(buf)
        except KeyboardInterrupt as e:
            pass
        except EnvironmentError as e:
            if e.errno == errno.EPIPE:
                pass
            raise
        return True
